#include <stdio.h>
#include <crtdbg.h>

#include "ASFIndex.h"

///////////////////////////////////////////////////////////////////////////

class ASFIndexChainNode {
public:
	enum { ENTS=2048 };

	ASFIndexChainNode *next;

	ASFIndexEntry ient[ENTS];
	int num_ents;

	ASFIndexChainNode() {
		num_ents = 0;
		next = NULL;
	}

	bool add(__int64 pos, long size, bool is_keyframe, long pres_time, unsigned char seq) {
		if (num_ents < ENTS) {
			ient[num_ents].pos			= pos;
			ient[num_ents].size			= is_keyframe ? size : 0x80000000+size;
			ient[num_ents].pres_time	= pres_time;
			ient[num_ents].seq			= seq;
			++num_ents;
			return true;
		}
		return false;
	}

	void put(ASFIndexEntry *&ASFe2ptr) {
		int i;

		for(i=0; i<num_ents; i++)
			*ASFe2ptr++ = ient[i];
	}

};

///////////////////////////////////////////////////////////////////////////

ASFIndexChain::ASFIndexChain() {
	head = tail = NULL;
	total_ents = 0;
}

void ASFIndexChain::delete_chain() {
	ASFIndexChainNode *aicn = head,*aicn2;

	while(aicn) {
		aicn2 = aicn->next;
		delete aicn;
		aicn = aicn2;
	}

	head = tail = NULL;
}

ASFIndexChain::~ASFIndexChain() {
	delete_chain();
}

bool ASFIndexChain::add(__int64 pos, long size, bool is_keyframe, long pres_time, unsigned char seq) {
	if (!tail || !tail->add(pos, size, is_keyframe, pres_time, seq)) {
		ASFIndexChainNode *aicn = new ASFIndexChainNode();

		if (tail) tail->next = aicn; else head=aicn;
		tail = aicn;

		if (tail->add(pos, size, is_keyframe, pres_time, seq)) {
			++total_ents;
			return true;
		}

		return false;
	}

	++total_ents;

	return true;
}

void ASFIndexChain::put(ASFIndexEntry *ASFe2tbl) {
	ASFIndexChainNode *aicn = head;

	while(aicn) {
		aicn->put(ASFe2tbl);
		aicn=aicn->next;
	}

	delete_chain();
}

ASFIndex::ASFIndex() {
	index = NULL;
}

ASFIndex::~ASFIndex() {
	delete index;
}

bool ASFIndex::makeIndex() {

	// extra index entry avoids a crash in the packet read code

	if (!allocateIndex(total_ents)) return false;

	put(indexPtr());

	return true;
}

void ASFIndex::clear() {
	delete_chain();
	delete index;
	index = NULL;
	total_ents = 0;
}

void ASFIndex::Transfer(ASFIndex *src) {
	clear();

	this->head		= src->head;
	this->tail		= src->tail;
	this->total_ents= src->total_ents;

	this->index		= src->index;
	this->index_len	= src->index_len;

	src->head		= NULL;
	src->tail		= NULL;
	src->total_ents	= 0;
	src->index		= NULL;
	src->index_len	= NULL;
}
