#ifndef f_AVIOUTPUTWAV_H
#define f_AVIOUTPUTWAV_H

#include <windows.h>
#include <vfw.h>

#include "AVIOutput.h"

class FastWriteStream;

class AVIOutputWAV : public AVIOutput {
private:
	HANDLE		hFile;
	bool		fHeaderOpen;
	DWORD		dwBytesWritten;
	FastWriteStream	*fastIO;

	void _writeHdr(void *data, long len);
	void _seekHdr(__int64 i64NewPos);
	void _write(void *data, int len);

public:
	AVIOutputWAV();
	~AVIOutputWAV();

	BOOL initOutputStreams();
	BOOL init(const char *szFile, LONG xSize, LONG ySize, BOOL videoIn, BOOL audioIn, LONG bufferSize, BOOL is_interleaved);
	BOOL finalize();
	BOOL isPreview();

	void writeIndexedChunk(FOURCC ckid, LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer);
};

#endif
