#ifndef f_AUDIO_H
#define f_AUDIO_H

#include <windows.h>
#include <mmsystem.h>
#include <msacm.h>

#include "FrameSubset.h"

typedef void (*AudioFormatConverter)(void *, void *, long);
typedef long (*AudioPointSampler)(void *, void *, long, long, long);
typedef long (*AudioUpSampler)(void *, void *, long, long, long);
typedef long (*AudioDownSampler)(void *, void *, long *, int, long, long, long);

class AudioSource;

///////

class AudioStream {
protected:
	WAVEFORMATEX *format;
	long format_len;

	AudioStream *source;
	long samples_read;
	long stream_len;
	long stream_limit;

	AudioStream();

	WAVEFORMATEX *AllocFormat(long len);
public:
	virtual ~AudioStream();

	virtual WAVEFORMATEX *GetFormat();
	virtual long GetFormatLen();
	virtual long GetSampleCount();
	virtual long GetLength();

	virtual long _Read(void *buffer, long max_samples, long *lplBytes);
	virtual long Read(void *buffer, long max_samples, long *lplBytes);
	virtual bool Skip(long samples);
	virtual void SetSource(AudioStream *source);
	virtual void SetLimit(long limit);
	virtual BOOL isEnd();
	virtual BOOL _isEnd();
};

class AudioStreamSource : public AudioStream {
private:
	AudioSource *aSrc;
	WAVEFORMATEX *pwfexTempInput;
	long cur_samp;
	long end_samp;
	HACMSTREAM hACStream;
	ACMSTREAMHEADER ashBuffer;
	void *inputBuffer;
	void *outputBuffer;
	char *outputBufferPtr;
	long lPreskip;
	bool fZeroRead;
	bool fStart;

	enum { INPUT_BUFFER_SIZE = 16384 };

public:
	AudioStreamSource(AudioSource *src, long first_sample, long max_sample, BOOL allow_decompression);
	~AudioStreamSource();

	long _Read(void *buffer, long max_samples, long *lplBytes);
	bool Skip(long samples);
	BOOL _isEnd();
};

class AudioStreamConverter : public AudioStream {
private:
	AudioFormatConverter convRout;
	void *cbuffer;
	int bytesPerInputSample, bytesPerOutputSample;
	long samp_frac;
	long accum;
	void *holdover_ptr;

	enum { BUFFER_SIZE=512 };

public:
	AudioStreamConverter(AudioStream *source, bool to_16bit, bool to_stereo);
	~AudioStreamConverter();

	long _Read(void *buffer, long max_samples, long *lplBytes);
	BOOL _isEnd();
};

class AudioStreamResampler : public AudioStream {
private:
	AudioPointSampler ptsampleRout;
	AudioUpSampler upsampleRout;
	AudioDownSampler dnsampleRout;
	void *cbuffer;
	int bytesPerSample;
	long samp_frac;
	long accum;
	int holdover;
	long *filter_bank;
	int filter_width;
	bool fHighQuality;

	enum { BUFFER_SIZE=512 };

	long Upsample(void *buffer, long samples, long *lplBytes);
	long Downsample(void *buffer, long samples, long *lplBytes);

public:
	AudioStreamResampler(AudioStream *source, long new_rate, bool integral_rate, bool high_quality);
	~AudioStreamResampler();

	long _Read(void *buffer, long max_samples, long *lplBytes);
	BOOL _isEnd();
};

class AudioCompressor : public AudioStream {
private:
	HACMSTREAM hACStream;
	HACMDRIVER hADriver;
	ACMSTREAMHEADER ashBuffer;
	WAVEFORMATEX *pwfexTempOutput;
	void *inputBuffer;
	void *outputBuffer;
	char *outputBufferPtr;
	void *holdBuffer;
	long holdBufferSize;
	long holdBufferOffset;
	BOOL fStreamEnded;
	LONG bytesPerInputSample;
	LONG bytesPerOutputSample;

	enum { INPUT_BUFFER_SIZE = 16384 };

	void	ResizeHoldBuffer(long lNewSize);
	void	WriteToHoldBuffer(void *data, long lBytes);

public:
	AudioCompressor(AudioStream *src, WAVEFORMATEX *dst_format, long dst_format_len);
	~AudioCompressor();
	void CompensateForMP3();
	void *	Compress(long lInputSamples, long *lplSrcInputSamples, long *lplOutputBytes, long *lplOutputSamples);
	BOOL	isEnd();
};

class AudioL3Corrector {
private:
	long samples, frame_bytes, read_left;
	bool header_mode;
	char hdr_buffer[4];

public:
	AudioL3Corrector();
	long ComputeByterate(long sample_rate);
	void Process(void *buffer, long bytes);
};

class AudioSubset : public AudioStream {
private:
	FrameSubset subset;
	FrameSubsetNode *pfsnCur;
	int iOffset;
	long lSrcPos;
	long lSkipSize;

	char skipBuffer[512];

public:
	AudioSubset(AudioStream *, FrameSubset *, long, long);
	~AudioSubset();
	long _Read(void *, long, long *);
	BOOL _isEnd();
};

#endif
