#ifndef f_VIRTUALDUB_FILTERSYSTEM_H
#define f_VIRTUALDUB_FILTERSYSTEM_H

#include <windows.h>

#include "List.h"
#include "vbitmap.h"
#include "filter.h"

class FilterActivation;
class FilterInstance;
class FilterStateInfo;
class FilterSystemBitmap;

class FilterSystem {
private:
	DWORD dwBufferLockFlags;
	DWORD dwFlags;
	int iBitmapCount;

	enum { FILTERS_INITIALIZED = 0x00000001L };

	FilterSystemBitmap *bitmap;
	VFBitmap *bmLast;
	List *listFilters;

	HBITMAP hbmSrc;
	HDC		hdcSrc;
	HGDIOBJ	hgoSrc;

	HANDLE hFileShared;
	unsigned char *lpBuffer;
	long lAdditionalBytes;
	bool fSharedWindow;

	void AllocateVBitmaps(int count);
	void AllocateBuffers(LONG lTotalBufferNeeded);
	void ClearBufferLocks();
	void LockBuffer(int buffer);
	void UnlockBuffer(int buffer);
	BOOL IsBufferLocked(int buffer);

public:
	FilterSystem();
	~FilterSystem();
	void prepareLinearChain(List *listFA, Pixel *src_pal, PixDim src_width, PixDim src_height, int src_depth, int dest_depth);
	void initLinearChain(List *listFA, Pixel *src_pal, PixDim src_width, PixDim src_height, int src_depth, int dest_depth);
	int ReadyFilters(FilterStateInfo *);
	int RunFilters();
	int RunFilters(FilterInstance *pfiStopPoint);
	void DeinitFilters();
	void DeallocateBuffers();
	VFBitmap *InputBitmap();
	VFBitmap *OutputBitmap();
	VFBitmap *LastBitmap();
	bool isRunning();

	void getOutputMappingParams(HANDLE&, LONG&);
};

#endif
