#ifndef f_FILTERS_H
#define f_FILTERS_H

#include <malloc.h>

#include <windows.h>
#include <vfw.h>

#include "List.h"
#include "VBitmap.h"
#include "FilterSystem.h"
#include "filter.h"

//////////////////

struct CScriptObject;

//////////////////

#ifndef f_FILTER_GLOBALS
#define EXTERN extern
#define INIT(x)
#else
#define EXTERN
#define INIT(x) =x
#endif

///////////////////

class FilterInstance : public ListNode, public FilterActivation {
public:
	VFBitmap realSrc, realDst, realLast;
	LONG flags;
	HBITMAP hbmDst, hbmLast;
	HGDIOBJ hgoDst, hgoLast;
	void *pvDstView, *pvLastView;
	int srcbuf, dstbuf;
	bool fNoDeinit;

	///////

	FilterInstance();
	FilterInstance(const FilterInstance& fi);
	FilterInstance(FilterDefinition *);
	~FilterInstance();

	FilterInstance *Clone();
	void Destroy();
	void ForceNoDeinit();
};

class FilterPreview : public IFilterPreview {
private:
	HWND hdlg, hwndButton;
	HWND hwndParent;
	HDRAWDIB hdd;
	FilterSystem filtsys;
	BITMAPINFOHEADER bih;
	FilterStateInfo fsi;
	List *pFilterList;
	FilterInstance *pfiThisFilter;

	FilterPreviewButtonCallback		pButtonCallback;
	void							*pvButtonCBData;
	FilterPreviewSampleCallback		pSampleCallback;
	void							*pvSampleCBData;

	static BOOL CALLBACK DlgProc(HWND hdlg, UINT message, UINT wParam, LONG lParam);
	long FetchFrame();
	long FetchFrame(long);

public:
	FilterPreview(List *, FilterInstance *);
	~FilterPreview();

	void SetButtonCallback(FilterPreviewButtonCallback, void *);
	void SetSampleCallback(FilterPreviewSampleCallback, void *);

	bool isPreviewEnabled();
	void InitButton(HWND);
	void Toggle(HWND);
	void Display(HWND, bool);
	void RedoFrame();
	void UndoSystem();
	void RedoSystem();
	void Close();
	bool SampleCurrentFrame();
	long SampleFrames();
};

//////////

EXTERN FilterModule		*filter_module_list INIT(0);
EXTERN FilterDefinition *filter_list;
EXTERN List				g_listFA;

EXTERN FilterSystem filters;

int					FilterAutoloadModules(int &fail_count);
void				FilterLoadModule(char *szModule);
void				FilterUnloadModule(FilterModule *fm);
void				FilterUnloadAllModules();
FilterDefinition *	FilterAdd(FilterModule *fm, FilterDefinition *pfd, int fd_len);
void				FilterRemove(FilterDefinition *fd);


LONG FilterGetSingleValue(HWND hWnd, LONG cVal, LONG lMin, LONG lMax, char *title);

#undef EXTERN
#undef INIT

#endif
