#include <stdio.h>

#include <windows.h>
#include <commctrl.h>

#include "resource.h"
#include "filter.h"

extern HINSTANCE g_hInst;

///////////////////////////////////

static void __declspec(naked) asm_fieldswap(void *data, int bytes4, int bytes1, int height, long pitch) {
	__asm {
		push	ebp
		push	edi
		push	esi
		push	ebx

		mov		esi,[esp+4+16]
		mov		edx,[esp+16+16]
		mov		edi,esi
		mov		ecx,[esp+12+16]
		mov		eax,[esp+20+16]
		shr		eax,1
		add		edi,eax
yloop:
		mov		ebp,[esp+8+16]
xloop:
		mov		eax,[esi+ebp]
		mov		ebx,[edi+ebp]
		mov		[esi+ebp],ebx
		mov		[edi+ebp],eax
		add		ebp,4
		jne		xloop

		or		ecx,ecx
		jz		no_extra
xloop_bytes:
		mov		al,[esi+ebp]
		mov		bl,[edi+ebp]
		mov		[esi+ebp],bl
		mov		[edi+ebp],al
		inc		ebp
		cmp		ebp,ecx
		jne		xloop_bytes

no_extra:
		add		esi,[esp+20+16]
		add		edi,[esp+20+16]
		dec		edx
		jne		yloop

		pop		ebx
		pop		esi
		pop		edi
		pop		ebp
		ret
	}
}

///////////////////////////////////

int fieldswap_run(const FilterActivation *fa, const FilterFunctions *ff) {	
	asm_fieldswap(
			fa->src.data + fa->src.w,
			-fa->src.w*4,
			0,
			fa->src.h/2,
			fa->src.pitch*2
			);

	return 0;
}

long fieldswap_param(FilterActivation *fa, const FilterFunctions *ff) {
	return 0;
}

FilterDefinition filterDef_fieldswap={
	0,0,NULL,
	"field swap",
	"Swaps interlaced fields in the image.\n\n[Assembly optimized]",
	NULL,NULL,
	0,
	NULL,NULL,
	fieldswap_run,
	fieldswap_param,
	NULL,
	NULL,
};
