/********************************************************

	AVI player, ver. 0.52
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/
#ifndef _IAVIPLAYER_
#define _IAVIPLAYER_

//#include <loader.h>
#include <except.h>
#include <image.h>
#include <infotypes.h>
#include <videodecoder.h>
typedef void (*DRAWFUNC)(void*);
typedef void (*DRAWFUNC2)(CImage*);
typedef void (*KILLHANDLER)(int);
typedef int (*AUDIOFUNC)(void*, int);
/**
 *
 *   This class is meant to contain all code that is
 * not related to graphical interface of AVI player: you provide
 * an interface ( buttons, windows, etc. ), this class
 * provides you with video data and performs audio playback.
 *
 *   NEVER call playback-controlling functions ( even indirectly
 * through event processing calls, such as qApp->processEvents
 * in Qt ) from its callbacks. 
 *
 *    Usage:
 *   
 *   Call initPlayer(), specifying file name of AVI file, bit depth
 * of physical screen and optional file name of subtitle file.
 * Catch FatalError if player can't be constructed. Set two callbacks:
 * kill handler ( will be called when player stops ) and draw callback
 * ( called each frame during  playback and frequently if paused. Takes
 * non-zero pointer to video data or NULL if frame sholdn't be drawn ). 
 *  Prepare to draw video and call start(). Player immediately starts
 * playing. Its state can be controlled by calls play()/pause()/reseek(),
 * player can be stopped by stop() and started again by start().
 * Once again: don't try to call these functions from draw callback or 
 * your program will burn in hell forever.
 *  Player can be closed by endPlayer() and destroyed by 'delete'. Deleting
 * automatically stops playback and frees all resources.
 *  You can use the same player for several files sequentially, embracing
 * each file in initPlayer()/endPlayer() brackets.
 *  
 *  Current player implementation uses 3 threads ( + one thread from your
 * main() function ), 3 mutexes and 3 condition variables. It means that 
 * any bug in synchronization system can easily deadlock the whole player :)
 * Contact me if you find one.
 *
 */
class IAviPlayer
{
public:
    virtual ~IAviPlayer();
    virtual int initPlayer(const char* filename, int bitdepth, const char* subfile=NULL) throw(FatalError)=0;
    virtual int setColorSpace(int csp, bool test_only) =0;
    virtual void endPlayer() =0;

    virtual void setDrawCallback(DRAWFUNC func) =0;
    virtual void setDrawCallback2(DRAWFUNC2 func) =0;
    virtual void setKillHandler(KILLHANDLER handler) =0;
    
    virtual void setAudioFunc(AUDIOFUNC func) =0;
    
    virtual void start() =0;
    virtual double reseek(double pos) =0;
    virtual int reseek_exact(double pos) =0;//nonzero if unable
    virtual int page_up() =0;//to next keyframe
    virtual int page_down() =0;//to prev keyframe ( the one before frame drawn last time )
    virtual void play() =0;
    virtual void pause(bool state) =0;
    virtual void stop() =0;

    virtual int isValid() =0;  //nonzero if between initPlayer and endPlayer
    virtual int isPaused() =0; //nonzero if paused
    virtual int isStopped() =0;//nonzero if valid, but not playing and not paused
		       //It means that draw callback won't be called periodically
    virtual int isPlaying() =0;//playing or paused
    
    virtual int width() =0;
    virtual int height() =0;
    virtual int fps() =0;
    virtual const char* fileName() =0;

    virtual double GetPos() =0;
    
    virtual const char* GetCurrentSubtitles() =0;
    virtual int HasSubtitles() =0;
    virtual double GetAudioLength() const =0;
    virtual double GetVideoLength() const =0;
    virtual const char* GetAudioFormat() const =0;
    virtual const char* GetVideoFormat() const =0;
    virtual double GetDrop() const =0;
    
    //
    // Audio/video sync correction
    //

    // argument in seconds
    virtual void setAsync(float async) =0;
    virtual float readAsync() =0;

    //
    // Async applied to subtitles before playback
    //
    
    // argument in seconds
    virtual void setSubAsync(float async) =0;
    virtual float readSubAsync() =0;
    // 0 mute, 1 maximum volume
    virtual void setVolume(float volume) =0;
    virtual float readVolume() =0;
    
    virtual const CodecInfo& GetCodecInfo() const =0;
    virtual void Restart() =0;
    
    virtual IRtConfig* GetRuntimeConfig() =0;
    
    virtual void setVideo(int) =0;
    virtual void setAudio(int) =0;    
    virtual int getVideo() =0;
    virtual int getAudio() =0;    
};

IAviPlayer* CreateAviPlayer();

double GetAvifileVersion();
#endif
