/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: config.c,v 1.4 1999/09/13 11:17:35 root Exp $";

/*
 * $Log: config.c,v $
 * Revision 1.4  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.3  1999/09/13 11:08:34  root
 * \#
 *
 * Revision 1.2  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.1  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"

#include "rpld_conf.tab.h"

extern FILE *yyin;

void
do_linux_kernel (struct client *c, struct clfile *f)
{
  struct clfile *bootsect, *kernel;
  int loaderlen;

#define VMLINUZ_LOADLEN_OFFSET 497

/* The book says we should load top downwards so 
 * we init bottom upwards ie fr is the second stage 
 * bootloader at 0x92000 */

/* Firstly we need to load the bootsector to work out stuff */
  bootsect = (struct clfile *) malloc (sizeof (struct clfile));
  bzero (bootsect, sizeof (struct clfile));

  bootsect->path = strdup (f->path);
  bootsect->offset = 0;
  bootsect->length = 0x200;
  bootsect->load_addr = 0x90000;

  cache_locally (bootsect);

  if (!bootsect->data)
    {
      fprintf (stderr, "Couldn't open %s for reading\n", f->path);
      exit (1);
    }
  if (bootsect->length < 0x200)
    {
      fprintf (stderr, "Only read %d bytes from %s\n", bootsect->length, f->path);
      exit (1);
    }

  /* FIXME: here we should add a pointer to the kernel parameter string */
  /* and allocate a clfile structure to hold it */

  loaderlen = (bootsect->data[VMLINUZ_LOADLEN_OFFSET]) ?
    (0x200 * (bootsect->data[VMLINUZ_LOADLEN_OFFSET])) : 0x800;


  kernel = (struct clfile *) malloc (sizeof (struct clfile));
  bzero (kernel, sizeof (struct clfile));

  kernel->path = strdup (f->path);
  kernel->offset = loaderlen + 0x200;
  kernel->length = -1;
  kernel->load_addr = 0x10000;

  kernel->next = c->files;
  c->files = kernel;

  /* Tag in the bootsector */
  bootsect->next = kernel;
  c->files = bootsect;


  /* Now set up f the secondary bootloader */

  f->offset = 0x200;
  f->length = loaderlen;
  f->load_addr = 0x90200;

}


void
parse_config ()
{
  FILE *file;

  file = fopen (CONFIG_FILE, "r");

  if (!file)
    {
      fprintf (stderr, "Cannot open config file %s\n", CONFIG_FILE);
      exit (1);
    }

  yyin = file;

  yyparse ();

  fclose (file);


}
