/* This coderl wos gemaked by Roman


typedef {
  char *text;
  slist *list;
} slist;
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "list.h"

/* --------------- */

int locate(char* text, slist* list)
{
  int dep=-1;
  int nfound=-1;
  slist *lst;

  lst = list;

#ifdef DEBUG
  fprintf(stderr,"\n locate: text=%s \t list=%x", text, list);
#endif

  while (lst != NULL && nfound!=0) { 
    dep++;
    nfound = strcmp(lst -> text,text);
    lst = (slist*)(lst -> list);
  }
  if (nfound) dep=-1;
  return(dep);
}

/* --------------- */

char *getNodeString(char* text, slist* llist, slist* glist)
{
  static char buf[100];
  int dep;

#ifdef DEBUG
  fprintf(stderr,"\n    gNS: text=%s \t llist=%x \t glist=%x", text, llist, glist);
#endif

  dep=locate(text,llist);  
  if (dep != -1) {
    sprintf(buf,"par %d ",dep);
  } else {      /* very assuming global */
    dep=locate(text,glist);
    if (dep==-1) {
      fprintf(stderr,"unknown symbol: %s\n",text);
      exit(3);
    } 
    sprintf(buf,"global %s ",text);
  } 
  return(buf);
}

/* --------------- */
 
slist* insert(char *text,slist* list, int globl)
{
  char* txt;
  slist* lst;
  slist* retlst;

#ifdef DEBUG
  fprintf(stderr,"\n insert: text=%s \t list=%x \t globl=%d", text, list,globl);
#endif

  if (globl) {
    if (locate(text,list) != -1) {
      fprintf(stderr,"duplicate global symbol %s\n",text);
      exit(3);
    }
  }

  lst = malloc(sizeof(slist));
  if (lst==NULL) {
    fprintf(stderr,"Out of Memory Haha!!!\n");
    exit(100);
  }
  txt = malloc(strlen(text)+1);
  if (txt==NULL) {
    fprintf(stderr,"Out of Memory Haha!!!\n");
    exit(100);
  }

  strcpy(txt,text);
  lst -> text = txt;

  if (globl && list!=NULL) {
    retlst = list;
    while (list -> list != NULL) {
      list = (slist*)(list -> list);
    }
    lst -> list = (struct slist*) NULL;
    list -> list = (struct slist*)lst;
  } 
  else {
    lst -> list = (struct slist*)list;
    retlst = lst;
  }
  
  return(retlst);
}
